#!/usr/bin/python
import RPi.GPIO as GPIO
GPIO.setmode(GPIO.BCM)
from lib_nrf24 import NRF24
import time, spidev, string, thread



pipes = [[0xe7, 0xe7, 0xe7, 0xe7, 0xe7], [0xc2, 0xc2, 0xc2, 0xc2, 0xc2]]

radio2 = NRF24(GPIO, spidev.SpiDev())
radio2.begin(0, 25)
radio2.setRetries(15,15)

radio2.setPayloadSize(32)
radio2.setChannel(0x60)
radio2.setDataRate(NRF24.BR_2MBPS)
radio2.setPALevel(NRF24.PA_MIN)

radio2.setAutoAck(True)
radio2.enableDynamicPayloads()
radio2.enableAckPayload()

radio2.openWritingPipe(pipes[0])
#radio2.openReadingPipe(1, pipes[1])

#radio2.startListening()
#radio2.stopListening()

radio2.printDetails()
#radio2.startListening()

def wait_for_read(x):
	recv = []
	radio2.openReadingPipe(1, pipes[1])
	radio2.startListening()
	while(1):
		print "Running..."
		while not radio2.available(pipe):
			time.sleep(100/10000.0)
		print "Received? "
		radio2.read(recv, radio2.getDynamicPayloadSize())
		print "Received: ",
		for A in recv:
			if chr(A) in string.printable:
				print chr(A) ,
			else:
				print "#" ,
		print ""

try:
	thread.start_new_thread( wait_for_read, ("",) )
except:
	print "Failed to create reading socket."

while True:
	ret_buf = []
	pipe = [0]
	msg = raw_input("Send Message: ")
	for A in msg:
		ret_buf.append( ord(A) )
	ret_buf.append( len(msg) )
#	for A in recv_buffer:
#		if chr(A) in string.printable:
#			print chr(A) ,
#		else:
#			print "#" ,
#	print ""
	radio2.writeAckPayload(1, ret_buf, len(ret_buf))
	print ("Sent: ") ,
	print (ret_buf)
