import sys, select, tty, termios, time, string, spidev, thread, signal
from lib_nrf24 import NRF24
import RPi.GPIO as GPIO
GPIO.setmode(11)		# GPIO.BCM

Pipes = [[0xe7, 0xe7, 0xe7, 0xe7, 0xe7], [0xc2, 0xc2, 0xc2, 0xc2, 0xc2]]
radio = NRF24( GPIO, spidev.SpiDev() )
radio.begin(0, 25)

radio.setRetries(15, 15)
radio.setPayloadSize(32)
radio.setChannel(0x60)

radio.setDataRate(NRF24.BR_2MBPS)
radio.setPALevel(NRF24.PA_MIN)

radio.setAutoAck(True)
radio.enableDynamicPayloads()
radio.enableAckPayload();

radio.openWritingPipe( Pipes[1] )
radio.openReadingPipe(1, Pipes[0] )
radio.startListening()

radio.printDetails()

def Send_Msg(send):
	Start = time.time()
	recv = []
	radio.write( send[:32] )
	Start = time.time()
	while not radio.isAckPayloadAvailable() and (Start - time.time()) < 5:
		radio.read( recv, radio.getDynamicPayloadSize() )
		ret = []
		for A in recv:
			if A < 32 or A > 126: continue
			ret.append(chr(A))
			if len(ret) > 31:break
                if send != ['\n']:
			print "Received: {}".format( "".join(ret) )
		return ret
	return "Failed"

if __name__ == '__main__':
	while(1):
		resp = ""
		Msg = raw_input("Enter Message: ")
		Message = []
		for A in Msg:
			if A in string.printable:
				Message.append(ord(A))
		Message = Message[:31]
		Message.append(len(Message))
		resp = Send_Msg(Message)
		Send_Msg(['\n'])
