import sys, select, tty, termios, time, string, spidev, thread, signal
from lib_nrf24 import NRF24
import RPi.GPIO as GPIO
GPIO.setmode(11)        # GPIO.BCM

Pipes = [[0xe7, 0xe7, 0xe7, 0xe7, 0xe7], [0xc2, 0xc2, 0xc2, 0xc2, 0xc2]]
radio = NRF24( GPIO, spidev.SpiDev() )
radio.begin(0, 25)

radio.setRetries(15, 15)
radio.setPayloadSize(256)
radio.setChannel(0x60)

radio.setDataRate(NRF24.BR_2MBPS)
radio.setPALevel(NRF24.PA_MIN)

radio.setAutoAck(True)
radio.enableDynamicPayloads()
radio.enableAckPayload();

radio.openWritingPipe( Pipes[1] )
radio.openReadingPipe( 1, Pipes[0] )
radio.startListening()

radio.printDetails()

def Recv_Msg():
	recv = []
	while not radio.available([0]):
		time.sleep(0.01)
	radio.read( recv, radio.getDynamicPayloadSize() )
	ret = []
	for A in recv:
		ret.append(chr(A))
	send = []
	if ret and ret != ['\n']:
		Send = "True"
		Cnt = ord(ret.pop())
		if Cnt != len(ret):
			print "Incorrect Count. Might be wrong. Got {} Assumed {}".format(len(ret), Cnt)
		for A in Send: send.append(ord(A))
		radio.writeAckPayload(1, send, len(send) )
		return ret
	elif ret == ['\n']:
		return "NL"
	return "Failed"

if __name__ == '__main__':
	resp = ""
	while(1):
		resp = Recv_Msg()
		if resp != "NL": print "Received: {}".format("".join(resp))
