import threading
from subprocess import Popen, PIPE
from time import sleep
import Tkinter as tk
import tkMessageBox, os
import RPi.GPIO as GPIO

os.system("chmod +x ./Stepper")

from os import listdir
class Console(tk.Frame):
	def __init__(self, master, *args, **kwargs):
		tk.Frame.__init__(self, master, *args, **kwargs)

		self.help = {}
		self.help["read_rfid"] = "This will start reading RFID cards when its enabled ( Green Writing )"
		self.help["save_btn"] = "This saves the current RFID cards, and their individual outputs."
		self.help["load_btn"] = "This loads up a specified RFID save file. Which will load all the RFID cards and their respective outputs."
		self.help["relay_enable"] = "This enables you to use the Relay as an output."
		self.help["relay_delay"] = "This is how much time it will be enabled for."
		self.help["relay_repeat"] = "This is how many times it will repeat ( If Pause is off, it will stay on for delay x repeat e.g. Delay=1, Repeat=5 it will stay on for 5 seconds. )"
		self.help["relay_pause"] = "Pause for 0.3 seconds after every relay repeat?"
		self.help["stepper_enable"] = "Enable the use of the Stepper Motor?"
		self.help["stepper_direction"] = "Which direction for the Stepper Motor."
		self.help["stepper_speed"] = "What speed, 1 is fast, (3-5 Recommended for accurate turns) 20 is slow. The faster you go, the more unstable the motor will be."
		self.help["stepper_turns"] = "Stepper motor turns. 550 is roughly a full turn."
		self.help["swi_btn"] = "Enable the use of the Red Button to trigger the output below."
		self.help["pir_btn"] = "Enable the PIR Sensor to trigger the output below."
		self.help["18b_btn"] = "Enable the DS18B20 Temperature sensor to trigger the output below."
		self.help["b20_input"] = "Temperature to trigger at ( Higher than this amount and it will trigger the output below )"
		self.help[" "] = " "

		self.win = tk.Frame(self)			# Main Window

		self.rfidDict = {}

		self.command		= ""			# Curent Command ( to Run )
		self.rfidArray		= []			# RFID Array with addresses
		self.rfidCnt		= 0			# RFID Count
		self.rfidAccept		= ["*"]			# RFID Allowed Array
		self.rfidSelected	= ""			# Current RFID Selected
		self.rfidIndex		= 0			# RFID Index in ListBox
		self.popen		= None			# Subprocess file no
		self.running		= False			# Subprocess Running?
		self.cmdoutput		= ""			# Output for the subprocess
		self.reading		= False			# Is Reading Output ( After [ and before ] )

		self.switchIsEnabled	= False			# Switch Input Enabled
		self.pirIsEnabled	= False			# Pir Input Enabled
		self.b20IsEnabled	= False			# b20 Input Enabled

		self.switchRunning	= True			# Switch thread running
		self.pirRunning		= True			# PIR thread running
		self.b20Running		= True			# 18B20 thread running

		self.b20Trigger		= 30.00

		self.relayEnabledA	= 0			# Enable relay output
		self.relayDelayA	= 1			# Relay delay in seconds
		self.relayRepeatA	= 1			# Repeat relay output
		self.relayPauseA	= 1			# Relay Pause before repeating ( Off for 0.5 seconds )

		self.stepperEnabledB	= 0			# Enable stepper output
		self.stepperTurnsB	= 1			# Stepper turn count
		self.stepperDirectionB	= "CW"			# Stepper Direction ( 1 Clockwise, -1 Counter Clockwise )
		self.stepperSpeedB	= 1 			# Stepper Speed ( 1=Fast, 20=slow )

		self.switchThread	= 0
		self.pirThread		= 0
		self.b20Thread		= 0

		master.protocol("WM_DELETED_WINDOW", self.exitProg)



		tk.Label(self.win, text="Delay").grid(row=6, rowspan=1, column=2, columnspan=1)
		tk.Label(self.win, text="Repeat").grid(row=6, rowspan=1, column=3, columnspan=1)
		tk.Label(self.win, text="Pause").grid(row=6, rowspan=1, column=4, columnspan=1)
		tk.Label(self.win, text="Relay").grid(row=7, rowspan=1, column=0, columnspan=1)
		tk.Label(self.win, text="Output:").grid(row=5, rowspan=1, column=0, columnspan=1)
		tk.Label(self.win, text="RFID:").grid(row=0, rowspan=1, column=0, columnspan=1)
		tk.Label(self.win, text="Sensors:").grid(row=1, rowspan=1, column=2, columnspan=1)
		tk.Label(self.win, text="Switch").grid(row=2, rowspan=1, column=2, columnspan=1)
		tk.Label(self.win, text="PIR").grid(row=3, rowspan=1, column=2, columnspan=1)
		tk.Label(self.win, text="18B20").grid(row=4, rowspan=1, column=2, columnspan=1)
		tk.Label(self.win, text="Stepper").grid(row=9, rowspan=1, column=0, columnspan=1)
		tk.Label(self.win, text="Direction").grid(row=8, rowspan=1, column=2, columnspan=1)
		tk.Label(self.win, text="Speed").grid(row=8, rowspan=1, column=3, columnspan=1)
		tk.Label(self.win, text="Turns").grid(row=8, rowspan=1, column=4, columnspan=1)
		tk.Label(self.win, text="Trigger").grid(row=5, rowspan=1, column=2, columnspan=1)
		tk.Label(self.win, text="Trigger Temp").grid(row=3, rowspan=1, column=5, columnspan=2)



		self.swiInd = tk.Label(self.win, text="Off")
		self.swiInd.configure(fg="red")
		self.swiInd.grid(row=2, rowspan=1, column=4, columnspan=1)

		self.pirInd = tk.Label(self.win, text="Off")
		self.pirInd.configure(fg="red")
		self.pirInd.grid(row=3, rowspan=1, column=4, columnspan=1)

		self.b20Ind = tk.Label(self.win, text="Off")
		self.b20Ind.configure(fg="red")
		self.b20Ind.grid(row=4, rowspan=1, column=4, columnspan=1)

		self.rfidList = tk.Listbox(self.win)			# List of all the RFID Addresses.
		self.rfidList.grid(row=1, rowspan=4, column=0, columnspan=2)

		self.rfidName = tk.Label(self.win, text="None")		# RFID Address
		self.rfidName.grid(row=5, rowspan=1, column=1, columnspan=1)


		self.logList = tk.Listbox(self.win)			# Log all messages to this box!
		self.logList.grid(row=11, rowspan=7, column=0, columnspan=6)
		self.logList.configure(width="50")
		self.logList.bind('<<ListboxSelect>>')



		self.b20Input = tk.Entry(self.win)
		self.b20Input.config(width=5, state="disabled")
		self.b20Input.myName = "b20_input"
		self.b20Input.bind("<3>", self.helpMe)
		self.b20Input.grid(row=4, rowspan=1, column=5, columnspan=1)

		self.relayEnable = tk.Button(self.win, text="Off", bg="red", command=self.relayClicked)
		self.relayEnable.myName = "relay_enable"
		self.relayEnable.bind("<3>", self.helpMe)
		self.relayEnable.grid(row=7, rowspan=1, column=1, columnspan=1)

		self.relayDelay	= tk.Entry(self.win)
		self.relayDelay.myName = "relay_delay"
		self.relayDelay.bind("<3>", self.helpMe)
		self.relayDelay.grid(row=7, rowspan=1, column=2, columnspan=1)
		self.relayDelay.config(width=5, state="disabled")

		self.relayRepeat = tk.Entry(self.win)
		self.relayRepeat.myName = "relay_repeat"
		self.relayRepeat.bind("<3>", self.helpMe)
		self.relayRepeat.grid(row=7, rowspan=1, column=3, columnspan=1)
		self.relayRepeat.config(width=5, state="disabled")

		self.relayPause = tk.Button(self.win, text="On", bg="green", command=self.relayTogPause, state="disabled")
		self.relayPause.myName = "relay_pause"
		self.relayPause.bind("<3>", self.helpMe)
		self.relayPause.grid(row=7, rowspan=1, column=4, columnspan=1)

		self.stepperEnable = tk.Button(self.win, text="Off", bg="red", command=self.stepperClicked)
		self.stepperEnable.myName = "stepper_enable"
		self.stepperEnable.bind("<3>", self.helpMe)
		self.stepperEnable.grid(row=9, rowspan=1, column=1, columnspan=1)

		self.stepperDirList = ["CW", "CCW"]
		self.stepperDirVar = tk.StringVar(self.win)
		self.stepperDirVar.set(self.stepperDirList[0])

		self.stepperDirection = apply(tk.OptionMenu, (self.win, self.stepperDirVar) + tuple(self.stepperDirList))
		self.stepperDirection.grid(row=9, rowspan=1, column=2, columnspan=1)
		self.stepperDirection.myName= "stepper_direction"
		self.stepperDirection.bind("<3>", self.helpMe)
		self.stepperDirection.config(width=3, state="disabled")

		self.stepperSpeed = tk.Entry(self.win)
		self.stepperSpeed.myName = "stepper_speed"
		self.stepperSpeed.bind("<3>", self.helpMe)
		self.stepperSpeed.config(width=5, state="disabled")
		self.stepperSpeed.grid(row=9, rowspan=1, column=3, columnspan=1)

		self.stepperTurns = tk.Entry(self.win)
		self.stepperTurns.myName = "stepper_turns"
		self.stepperTurns.bind("<3>", self.helpMe)
		self.stepperTurns.config(width=5, state="disabled")
		self.stepperTurns.grid(row=9, rowspan=1, column=4, columnspan=1)

		self.rfidRead = tk.Button(self.win, text="Read RFID", command=self.readRfid, fg="red")
		self.rfidRead.myName = "read_rfid"
		self.rfidRead.bind("<3>", self.helpMe)
		self.rfidRead.grid(row=0, column=1, columnspan=1)

		self.swiButton = tk.Button(self.win, text="Off", command=self.togSwitch)
		self.swiButton.myName = "swi_btn"
		self.swiButton.bind("<3>", self.helpMe)
		self.swiButton.grid(row=2, rowspan=1, column=3, columnspan=1)
		self.swiButton.configure(bg="red")

		self.pirButton = tk.Button(self.win, text="Off", command=self.togPir)
		self.pirButton.configure(bg="red")
		self.pirButton.myName = "pir_btn"
		self.pirButton.bind("<3>", self.helpMe)
		self.pirButton.grid(row=3, rowspan=1, column=3, columnspan=1)

		self.b20Button = tk.Button(self.win, text="Off", command=self.togB20)
		self.b20Button.myName = "18b_btn"
		self.b20Button.bind("<3>", self.helpMe)
		self.b20Button.grid(row=4, rowspan=1, column=3, columnspan=1)
		self.b20Button.configure(bg="red")

		self.saveButton = tk.Button(self.win, text="Save", command=self.saveData)
		self.saveButton.myName = "save_btn"
		self.saveButton.bind("<3>", self.helpMe)
		self.saveButton.grid(row=0, rowspan=1, column=2, columnspan=1)

		self.loadButton = tk.Button(self.win, text="Load", command=self.loadData)
		self.loadButton.myName = "load_btn"
		self.loadButton.bind("<3>", self.helpMe)
		self.loadButton.grid(row=0, rowspan=1, column=3, columnspan=1)


		self.rfidClicky = tk.IntVar()
		self.rfidCheck = tk.Checkbutton(self.win, variable=self.rfidClicky, command=self.cbClick)
		self.rfidCheck.grid(row=5, rowspan=1, column=3, columnspan=1)




		self.rfidList.bind('<<ListboxSelect>>', self.listClicked)



		


		self.win.pack(side="left", fill="both")

	def helpMe(self, event):
		#print "Right Clicked: {}".format(event.widget.myName)
		tkMessageBox.showinfo("Help for {}".format(event.widget.myName), "The widget {}:\n{}".format(event.widget.myName, self.help[event.widget.myName]))
		#print "Help for {}: {}".format(event.widget.myName, self.help[event.widget.myName])

	def saveData(self):
		print "Start of Save."
		with open('/etc/PridopiaSave.txt', 'w') as SaveFile:
			SaveFile.write("RFID[\n")
			for Addr in self.rfidArray:
				if Addr in self.rfidAccept:
					self.rfidDict[Addr] = "True"
					SaveFile.write("[{},{}]\n".format(Addr, "True"))
					#print "[{},{}]".format(Addr, "True")
				else:
					self.rfidDict[Addr] = "False"
					SaveFile.write("[{},{}]\n".format(Addr, "False"))
					#print "[{},{}]".format(Addr, "False")
			SaveFile.write("]\n\n")		# END OF RFID DATA.

			SaveFile.write("Relay[\n")
			SaveFile.write("Delay:{}\n".format(self.relayDelay.get()))
			SaveFile.write("Repeat:{}\n".format(self.relayRepeat.get()))
			SaveFile.write("Pause:{}\n".format(self.relayPauseA))
			SaveFile.write("]\n\n")

			SaveFile.write("Stepper[\n")
			SaveFile.write("Direction:{}\n".format(self.stepperDirVar.get()))
			SaveFile.write("Speed:{}\n".format(self.stepperSpeed.get()))
			SaveFile.write("Turns:{}\n".format(self.stepperTurns.get()))
			SaveFile.write("]\n\n")

			SaveFile.write("Sensors[\n")
			SaveFile.write("Switch:{}\n".format(int(self.switchIsEnabled)))
			SaveFile.write("PIR:{}\n".format(int(self.pirIsEnabled)))
			SaveFile.write("DS18B20:{}:{}\n".format(int(self.b20IsEnabled), self.b20Input.get()))
			SaveFile.write("]\n\n")

		print "End of Save."

	def loadData(self):
		print "Loading File..."
		try:
			with open("/etc/PridopiaSave.txt" ,"r") as File:
				Data = File.read()
			Data = Data.split("\n\n")

			self.rfidArray = []
			self.rfidAccept = []

			self.relayDelay.delete(0, tk.END)
			self.relayRepeat.delete(0, tk.END)
			self.relayPause.config(state="disabled")

			self.stepperEnable.config(text="Off", bg="red")
			self.stepperSpeed.delete(0, tk.END)
			self.stepperTurns.delete(0, tk.END)

			self.switchIsEnabled = False
			self.swiButton.configure(bg="red", text="Off")
			self.switchRunning = False
			
			self.pirIsEnabled = False
			self.pirButton.configure(bg="red", text="Off")
			self.pirRunning = False

			self.b20IsEnabled = False
			self.b20Button.configure(bg="red", text="Off")
			self.b20Running = False
			self.b20Input.configure(state="disabled")
			self.b20Input.delete(0, tk.END)

			self.switchRunning = False
			self.switchThread = 0
			self.pirRunning = False
			self.pirThread = 0
			self.b20Running = False
			self.b20Thread = 0


			for A in Data:
				NewData = A.split("\n")
				Cat = NewData[0]
				if Cat[:4] == "RFID":
					for Addr in NewData[1:-1]:		# Loop through RFID List
						Data = Addr[1:-1]
						Data = Data.split(",")
						RFIDAddr = Data[0]
						self.rfidArray.append(RFIDAddr)
						if Data[1] == "True":
							self.rfidAccept.append(RFIDAddr)
				elif Cat[:5] == "Relay":
					for Settings in NewData[1:-1]:
						Settings = Settings.split(":")
						if Settings[0] == "Delay":
							if Settings[1] != "X":
								self.relayEnabledA = 1
								self.relayEnable.configure(bg="green", text="On", state="normal")
								self.relayDelay.config(state="normal")
								self.relayRepeat.config(state="normal")
								self.relayPause.config(state="normal")

								self.relayDelayA = float(Settings[1])
								self.relayDelay.insert(0, Settings[1])
							else:
								self.relayDelayA = -1
								self.relayEnable.configure(bg="red", text="Off")
								self.relayDelay.config(state="disabled")
								self.relayRepeat.config(state="disabled")
								self.relayPause.config(state="disabled")
						elif Settings[0] == "Repeat":
							if self.relayDelayA > 0:
								self.relayRepeatA = int(Settings[1])
								self.relayRepeat.insert(0, Settings[1])
							else:
								self.relayRepeatA = -1
						elif Settings[0] == "Pause":
							if self.relayDelayA > 0:
								self.relayPauseA = int(Settings[1])
								self.relayPause.config()
							else:
								self.relayPauseA = -1

				elif Cat[:7] == "Stepper":
					for Settings in NewData[1:-1]:
						Settings = Settings.split(":")
						if Settings[0] == "Direction":
							if Settings[1] != "X":
								if Settings[1] == "CW":
									self.stepperDirVar.set("CW")
								elif Settings[1] == "CCW":
									self.stepperDirVar.set("CCW")
								self.stepperEnabledB = 1
								self.stepperEnable.configure(bg="green", text="On")
								self.stepperDirection.config(state="normal")
								self.stepperSpeed.config(state="normal")
								self.stepperTurns.config(state="normal")
						elif Settings[0] == "Speed":
							self.stepperSpeed.insert(0, Settings[1])
						elif Settings[0] == "Turns":
							self.stepperTurns.insert(0, Settings[1])
				elif Cat[:7] == "Sensors":
					for Settings in NewData[1:-1]:
						Settings = Settings.split(":")
						if Settings[0] == "Switch":
							if Settings[1] == "1":
								self.switchIsEnabled = True
								self.swiButton.configure(bg="green", text="On")
								self.switchRunning = True
								self.switchThread = threading.Thread(target=self.pollSwitch).start()
							else:
								self.switchIsEnabled = False
								self.swiButton.configure(bg="red", text="Off")
								self.switchRunning = False
						elif Settings[0] == "PIR":
							if Settings[1] == "1":
								self.pirIsEnabled = True
								self.pirButton.configure(bg="green", text="On")
								self.pirRunning = True
								self.pirThread = threading.Thread(target=self.pollPir).start()
							else:
								self.pirIsEnabled = False
								self.pirButton.configure(bg="red", text="Off")
								self.pirRunning = False
								
						elif Settings[0] == "DS18B20":
							print "DS8B20:{} {} {}".format(Settings[0], Settings[1], Settings[2])
							if Settings[1] == "1":
								self.b20IsEnabled = True
								self.b20Button.configure(bg="black", text="On")
								self.b20Running = True
								self.b20Thread = threading.Thread(target=self.pollB20).start()
								self.b20Input.configure(state="normal")
								self.b20Input.insert(0, Settings[2])
							else:
								self.b20IsEnabled = False
								self.b20Button.configure(bg="red", text="Off")
								self.b20Running = False
								self.b20Input.configure(state="disabled")
								self.b20Input.delete(0, tk.END)
			self.rfidList.delete(0, tk.END)
			self.rfidCount = 0
			for A in self.rfidArray:
				self.rfidList.insert(tk.END, "Card {}:{}".format(self.rfidCount, A))
				if A in self.rfidAccept:
					self.rfidList.itemconfig(self.rfidCount, fg="black")
				else:
					self.rfidList.itemconfig(self.rfidCount, fg="red")
				self.rfidCount += 1
			self.rfidCnt = self.rfidCount

			print "Loaded Save File."
		except Exception as exc:
			print "An error occurred: Type: {} - Error: {}".format(type(exc), exc)

	def exitProg(self):
		self.stop()
		exit(0)

	def togSwitch(self):
		if self.switchIsEnabled:
			self.switchIsEnabled = False
			self.swiButton.configure(bg="red", text="Off")
			self.switchRunning = False
		else:
			self.switchIsEnabled = True
			self.swiButton.configure(bg="green", text="On")
			self.switchRunning = True
			self.switchThread = threading.Thread(target=self.pollSwitch).start()
		print "Toggle Switch"

	def togPir(self):
		if self.pirIsEnabled:
			self.pirIsEnabled = False
			self.pirButton.configure(bg="red", text="Off")
			self.pirRunning = False
		else:
			self.pirIsEnabled = True
			self.pirButton.configure(bg="green", text="On")
			self.pirRunning = True
			self.pirThread = threading.Thread(target=self.pollPir).start()
		print "Toggle PIR"

	def togB20(self):
		if self.b20IsEnabled:
			self.b20IsEnabled = False
			self.b20Button.configure(bg="red", text="Off")
			self.b20Running = False
			self.b20Input.configure(state="disabled")
		else:
			self.b20IsEnabled = True
			self.b20Button.configure(bg="green", text="On")
			self.b20Running = True
			self.b20Thread = threading.Thread(target=self.pollB20).start()
			self.b20Input.configure(state="normal")
		print "Toggle 18B20"

	def pollSwitch(self):
		print "Polling Switch..."
		GPIO.setup(27, GPIO.IN )
		while(self.switchRunning):
			input = GPIO.input(27)
			#print "Switch [{}]".format(input)
			if input==0:
				self.swiInd.configure(text="On", fg="green")
				self.log("Switch has been triggered.")
				self.trigger("*")
			else:
				self.swiInd.configure(text="Off", fg="red")
			sleep(0.1)

	def pollPir(self):
		print "Polling PIR..."
		GPIO.setup(22, GPIO.IN )
		while(self.pirRunning):
			input = GPIO.input(22)
			if GPIO.input(22)==0:
				self.pirInd.configure(text="On", fg="green")
				sleep(1)
				if GPIO.input(22)==0:
					self.log("PIR Sensor has been triggered.")
					self.trigger("*")
			while(GPIO.input(22)==0):
				sleep(0.2)
			self.pirInd.configure(text="Off", fg="red")
			sleep(0.1)

	def pollB20(self):
		print "Polling 18B20..."
		Temp = 0.00
		mypath = '/sys/bus/w1/devices/'
		while(self.b20Running):
			Files = listdir(mypath)
			b20Found=False
			for File in Files:
				if File[:2] == "28":
					with open('/sys/bus/w1/devices/'+File+'/w1_slave', 'r') as Fi:
						Data = Fi.read()
					Data = Data.split('\n')
					#print "Temp: {}".format(Data)
					if Data[0][-3:] == "YES":
						#print "Passed CRC."
						Data2 = Data[1].split("=")
						Temp = Data2[1]
						Temp = int(Temp)/1000.00
						self.b20Temperature = float(Temp)
						self.log("18B20 sensor: {:0.2f}c".format(Temp))
						if self.b20Input.get() != "":
							self.b20Trigger = float(self.b20Input.get())
						else:
							self.b20Trigger = 0
						if self.b20Trigger >=1 or self.b20Trigger <= -1:
							if self.b20Temperature > self.b20Trigger:
								self.log("18B20 Temperature has triggered -> {:0.2f}c.".format(Temp))
								self.trigger("*")
						else:
							print "No temperature trigger set!"
						Temp = "{:0.2f}c".format(Temp)
						self.b20Ind.configure(text=Temp, fg="black")
						b20Found=True
					else:
						self.b20Ind.configure(text="FAIL1", fg="red")
			if b20Found==False:
				self.b20Ind.configure(text="FAIL2", fg="red")
			sleep(1)

	def relayTogPause(self):
		if self.relayPauseA == 1:
			self.relayPauseA = 0
			self.relayPause.configure(bg="red", text="Off")

		else:
			self.relayPauseA = 1
			self.relayPause.configure(bg="green", text="On")



	def relayClicked(self):
		if self.relayEnabledA == 0:
			self.relayEnable.configure(bg="green", text="On")
			self.relayEnabledA = 1

			self.relayDelay.config(state="normal")
			self.relayRepeat.config(state="normal")
			self.relayPause.config(state="normal")
		else:
			self.relayEnable.configure(bg="red", text="Off")
			self.relayEnabledA = 0

			self.relayDelay.config(state="disabled")
			self.relayRepeat.config(state="disabled")
			self.relayPause.config(state="disabled")

	def stepperClicked(self):
		if self.stepperEnabledB == 0:
			self.stepperEnable.configure(bg="green", text="On")
			self.stepperEnabledB = 1

			self.stepperDirection.config(state="normal")
			self.stepperSpeed.config(state="normal")
			self.stepperTurns.config(state="normal")
		else:
			self.stepperEnable.configure(bg="red", text="Off")
			self.stepperEnabledB = 0

			self.stepperDirection.config(state="disabled")
			self.stepperSpeed.config(state="disabled")
			self.stepperTurns.config(state="disabled")

	def readRfid(self):
		self.command = ["python", "Read.py"]
		if self.running == True:
			self.rfidRead.configure(fg="red")
			self.stop()
			self.reading = False
			self.cmdoutput = ""
			self.running = False
		else:
			self.rfidRead.configure(fg="green")
			self.running = True
		threading.Thread(target=self.process).start()

	def process(self):
		while self.running:
			self.execute()

	def cbClick(self):
		if self.rfidClicky.get():
			if self.rfidSelected not in self.rfidAccept:
				self.rfidAccept.append(self.rfidSelected)
				self.rfidList.itemconfig(self.rfidIndex, fg="black", selectforeground="black")
		else:
			if self.rfidSelected in self.rfidAccept:
				self.rfidAccept.remove(self.rfidSelected)
				self.rfidList.itemconfig(self.rfidIndex, fg="red", selectforeground="red")

	def listClicked(self, event):
		self.rfidCheck.deselect()
		w = event.widget
		id = int(w.curselection()[0])
		print "Selected ID {}".format(id)
		val = w.get(id)
		self.rfidSelected = self.rfidArray[id]
		self.rfidIndex = id
		#print "{}:{} - was selected.".format(id, val)
		self.rfidName.configure(text=self.rfidSelected)
		if self.rfidSelected in self.rfidAccept:
			self.rfidCheck.select()
		else:
			self.rfidCheck.deselect()
		

	def triggerRelay(self):
		try:
			self.relayDelayA = float(self.relayDelay.get())
			self.relayRepeatA = int(self.relayRepeat.get())
		except:
			self.relayDelayA = 1
			self.relayRepeatA = 1
		self.log("Relay has been triggered. [{}] [{}] [{}]".format(self.relayDelayA, self.relayRepeatA, self.relayPauseA))
		for A in range(0, self.relayRepeatA):
			GPIO.output(17, 1)
			sleep(self.relayDelayA)
			GPIO.output(17, 0)
			if self.relayPauseA:
				sleep(0.5)

	def triggerStepper(self):
		print "Trying to launch: ./Stepper {} {} {}".format(self.stepperDirVar.get(), self.stepperSpeed.get(), self.stepperTurns.get())
		self.stepperProc = Popen(["./Stepper", self.stepperDirVar.get(), self.stepperSpeed.get(), self.stepperTurns.get()])
		returned = self.stepperProc.poll()
		self.log("Stepper has been triggered. [{}] [{}] [{}] ".format(self.stepperDirectionB, self.stepperSpeedB, self.stepperTurnsB))
		while returned == 0:
			print "Returned with: {}".format(returned)
			returned = self.stepperProc.poll()
		self.stepperProc.wait()

	def trigger(self, addr):
		print "Settings: {} {} {}".format(self.relayEnabledA, self.stepperEnabledB, (self.relayEnabledA & self.stepperEnabledB))
		if addr in self.rfidAccept or addr == "*":
			self.log("RFID card [{}] Triggered.".format(addr))
			self.relayThread = threading.Thread(target=self.triggerRelay)
			self.stepperThread = threading.Thread(target=self.triggerStepper)
			#print "Settings: {} {} {}".format(self.relayEnabledA, self.stepperEnabledA, (self.relayEnabledA & self.stepperEnabledA))
			GPIO.output(19, 1)
			if self.relayEnabledA == 1:
				self.relayThread.start()
			if self.stepperEnabledB:
				self.stepperThread.start()
			if self.stepperEnabledB == 0 & self.relayEnabledA == 0:
				sleep(1)
			if self.relayEnabledA==1:
				self.relayThread.join()		# Wait for both to start, then wait for finish.
			if self.stepperEnabledB:
				self.stepperThread.join()
			GPIO.output(19, 0)

	def show(self, addr):
		#print "Address: {}".format(addr)
		try:
			if addr not in self.rfidArray:
				for a in range(0, 5):
					GPIO.output(24, 1)
					sleep(0.1)
					GPIO.output(24, 0)
					sleep(0.1)
				self.rfidArray.append(addr)
				self.rfidList.insert(tk.END, "Card {}: {}".format(self.rfidCnt, addr))
				self.rfidList.itemconfig(self.rfidCnt, fg="red", selectforeground="red")
				self.rfidCnt += 1
				self.log("Card [{}] Added.".format(addr))
			else:
				if addr not in self.rfidAccept:
					self.log("Card [{}] recognised, but not accepted.".format(addr))
					GPIO.output(24, 1)

					for a in range(0, 4):
						GPIO.output(18, 1)
						sleep(0.1)
						GPIO.output(18, 0)
						sleep(0.1)

					GPIO.output(24, 0)
				elif addr in self.rfidAccept:
					self.log("Card [{}] recognised, and accepted.".format(addr))
					self.trigger(addr)
		except Exception as excep:
			print "Exception in show(): {} -- {}".format(type(excep), excep)

	def log(self, text):
		self.logList.insert(tk.END, text)
		self.logList.see(tk.END)

	def execute(self):
		try:
			self.popen = Popen(self.command, stdout=PIPE)
			while self.popen.poll() is None:
				#print "Going to readline Stdout Line..."
				char = self.popen.stdout.read(1)
				if char == "[":
					self.reading = True
					pass
				elif char == "]":
					self.reading = False
					print "Output [{}]".format(self.cmdoutput)
					self.show(self.cmdoutput)
					self.cmdoutput = ""
				elif self.reading:
					self.cmdoutput+=char
			#print "Process Killed."
		except Exception as exc:
			pass
			#print "Error - Type: {} -- Popen: {}".format(type(exc), self.popen)
		self.stop()

	def stop(self):
		if self.popen:
			try:
				self.popen.kill()
			except:
				pass
		self.running=False


if __name__ == '__main__':
	GPIO.setmode(GPIO.BCM)
	GPIO.setwarnings(False)

	GPIO.setup(17, GPIO.OUT)
	GPIO.setup(24, GPIO.OUT)
	GPIO.setup(19, GPIO.OUT)
	GPIO.setup(27, GPIO.IN)
	GPIO.setup(18, GPIO.OUT)
	GPIO.setup(5 , GPIO.OUT)
	GPIO.setup(6 , GPIO.OUT)
	GPIO.setup(12, GPIO.OUT)
	GPIO.setup(13, GPIO.OUT)
	GPIO.setup(22, GPIO.IN)


	root = tk.Tk()
	root.title("RFID Control Panel")
	Console(root).pack(expand=True, fill="both")
	root.mainloop()
