import re, os, sys, time
from Adafruit_8x8 import EightByEight
from subprocess import Popen, PIPE

Grid1 = EightByEight(address=0x70)
Grid2 = EightByEight(address=0x71)
Grid1.clear()
Grid2.clear()

BBC = 'feeds.bbci.co.uk/news/rss.xml?edition=uk'

BLACK, RED, GREEN, ORANGE, BLUE, MAGENTA, CYAN, WHITE = 30, 31, 32, 33, 34, 35, 36, 37

def printout(text, colour=WHITE):
	seq = "\x1b[%sm%s\x1b[0m" % (colour, text)
	sys.stdout.write(seq)
	sys.stdout.flush()

def Update_News(Url):
	News = []
	Video = []
	Audio = []
	Pictures = []
	DNull = open('/dev/null', 'w')
	printout("\nDownloading BBC RSS Feed. ", CYAN)
	Args = ['curl' , Url]
	Proc = Popen(Args, stdout=PIPE, stderr=DNull)
	printout("[DONE]\n", RED)
	Out = Proc.stdout.read()
	Find = re.findall("<title>([\S ]*)</title>", Out)
	Find.pop(0)
	Find.pop(0)

	for A in Find:
		if A[:5] == "VIDEO":
			Video.append(A[7:])
		elif A[:5] == "AUDIO":
			Audio.append(A[7:])
		elif A[:11] == "In pictures":
			Pictures.append(A[13:])
		elif A[:15] == "Day in pictures":
			Pictures.append(A[17:])
		else:
			News.append(A)

	return News[0]#, Video, Audio, Pictures

News = Update_News(BBC)

Font = [
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,		# 
0x04, 0x04, 0x04, 0x04, 0x04, 0x00, 0x04,		# !
0x00, 0x1b, 0x1b, 0x11, 0x00, 0x00, 0x00,		# "
0x0a, 0x0a, 0x1f, 0x0a, 0x1f, 0x0a, 0x0a,		# #
0x04, 0x0f, 0x14, 0x0e, 0x05, 0x1e, 0x04,		# $
0x18, 0x19, 0x02, 0x04, 0x08, 0x13, 0x03,		# %
0x0c, 0x12, 0x14, 0x08, 0x15, 0x12, 0x0d,		# &
0x0c, 0x04, 0x08, 0x00, 0x00, 0x00, 0x00,		# '
0x02, 0x04, 0x08, 0x08, 0x08, 0x04, 0x02,		# (
0x08, 0x04, 0x02, 0x02, 0x02, 0x04, 0x08,		# )
0x00, 0x04, 0x15, 0x0e, 0x15, 0x04, 0x00,		# *
0x00, 0x04, 0x04, 0x1f, 0x04, 0x04, 0x00,		# +
0x00, 0x00, 0x00, 0x00, 0x0c, 0x04, 0x08,		# ,
0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00,		# -
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04,		# .
0x00, 0x01, 0x02, 0x04, 0x08, 0x10, 0x00,		# /
0x0e, 0x11, 0x13, 0x15, 0x19, 0x11, 0x0e,		# 0
0x04, 0x0c, 0x04, 0x04, 0x04, 0x04, 0x0e,		# 1
0x0e, 0x11, 0x01, 0x02, 0x04, 0x08, 0x1f,		# 2
0x1f, 0x02, 0x04, 0x02, 0x01, 0x11, 0x0e,		# 3
0x02, 0x06, 0x0a, 0x12, 0x1f, 0x02, 0x02,		# 4
0x1f, 0x10, 0x1e, 0x01, 0x01, 0x11, 0x0e,		# 5
0x06, 0x08, 0x10, 0x1e, 0x11, 0x11, 0x0e,		# 6
0x1f, 0x01, 0x02, 0x04, 0x08, 0x08, 0x08,		# 7
0x0e, 0x11, 0x11, 0x0e, 0x11, 0x11, 0x0e,		# 8
0x0e, 0x11, 0x11, 0x0f, 0x01, 0x02, 0x0c,		# 9
0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x0c, 0x00,		# :
0x00, 0x0c, 0x0c, 0x00, 0x0c, 0x04, 0x08, 		# ;
0x00, 0x04, 0x08, 0x1f, 0x08, 0x04, 0x00, 		# <
0x00, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x00,		# =
0x00, 0x04, 0x02, 0x1f, 0x02, 0x04, 0x00,		# >
0x0e, 0x11, 0x01, 0x02, 0x04, 0x00, 0x04,		# ?
0x0e, 0x11, 0x17, 0x15, 0x17, 0x10, 0x0e,	 	# @
0x04, 0x0a, 0x0a, 0x11, 0x1f, 0x11, 0x11,		# A
0x1e, 0x11, 0x11, 0x1e, 0x11, 0x11, 0x1e,		# B
0x07, 0x08, 0x10, 0x10, 0x10, 0x08, 0x07,		# C
0x1e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x1e,		# D
0x1e, 0x10, 0x10, 0x1e, 0x10, 0x10, 0x1e,		# E
0x1f, 0x10, 0x10, 0x1c, 0x10, 0x10, 0x10,		# F
0x0e, 0x11, 0x10, 0x10, 0x17, 0x11, 0x0f,		# G
0x11, 0x11, 0x11, 0x1f, 0x11, 0x11, 0x11,		# H
0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x1f,		# I
0x0f, 0x02, 0x02, 0x02, 0x02, 0x0a, 0x04,		# J
0x11, 0x12, 0x14, 0x18, 0x14, 0x12, 0x11,		# K
0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1f,		# L
0x11, 0x1b, 0x15, 0x11, 0x11, 0x11, 0x11,		# M
0x11, 0x11, 0x19, 0x15, 0x13, 0x11, 0x11,		# N
0x0e, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e,		# O
0x1e, 0x11, 0x11, 0x11, 0x1e, 0x10, 0x10,		# P
0x0e, 0x11, 0x11, 0x11, 0x15, 0x13, 0x0f,		# Q
0x1e, 0x11, 0x11, 0x11, 0x1e, 0x11, 0x11,		# R
0x0e, 0x11, 0x10, 0x0e, 0x01, 0x11, 0x0e,		# S
0x1f, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,		# T
0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x0e,		# U
0x11, 0x11, 0x11, 0x11, 0x11, 0x0a, 0x04,		# V
0x11, 0x11, 0x11, 0x11, 0x15, 0x1b, 0x11,		# W
0x11, 0x11, 0x0a, 0x04, 0x0a, 0x11, 0x11,		# X
0x11, 0x11, 0x11, 0x0a, 0x04, 0x04, 0x04,		# Y
0x1f, 0x01, 0x02, 0x04, 0x08, 0x10, 0x1f,		# Z
0x1e, 0x10, 0x10, 0x10, 0x10, 0x10, 0x1e,		# [
0x00, 0x10, 0x08, 0x04, 0x02, 0x01, 0x00,		# \
0x0f, 0x01, 0x01, 0x01, 0x01, 0x01, 0x0f,		# ]
0x04, 0x0e, 0x15, 0x04, 0x04, 0x00, 0x00,		# ^
0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1f,		# _
0x00, 0x08, 0x04, 0x00, 0x00, 0x00, 0x00,		# `
0x00, 0x00, 0x0e, 0x01, 0x0f, 0x11, 0x0f,		# a
0x10, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x1e,		# b
0x00, 0x00, 0x0f, 0x10, 0x10, 0x10, 0x0f,		# c
0x01, 0x01, 0x01, 0x0f, 0x11, 0x11, 0x0f,		# d
0x00, 0x00, 0x0e, 0x11, 0x1f, 0x10, 0x0f,		# e
0x02, 0x05, 0x04, 0x0e, 0x04, 0x04, 0x04,		# f
0x00, 0x00, 0x0f, 0x11, 0x0f, 0x01, 0x1e,		# g
0x10, 0x10, 0x10, 0x1e, 0x11, 0x11, 0x11,		# h
0x00, 0x04, 0x00, 0x04, 0x04, 0x04, 0x04,		# i
0x02, 0x00, 0x02, 0x02, 0x02, 0x12, 0x0c,		# j
0x08, 0x08, 0x09, 0x0a, 0x0c, 0x0a, 0x09,		# k
0x0c, 0x04, 0x04, 0x04, 0x04, 0x04, 0x0e,		# l
0x00, 0x00, 0x1b, 0x15, 0x15, 0x15, 0x11,		# m
0x00, 0x00, 0x16, 0x19, 0x11, 0x11, 0x11,		# n
0x00, 0x00, 0x0e, 0x11, 0x11, 0x11, 0x0e,		# o
0x00, 0x00, 0x1e, 0x11, 0x1e, 0x10, 0x10,		# p
0x00, 0x00, 0x0f, 0x11, 0x0f, 0x01, 0x01,		# q
0x00, 0x00, 0x16, 0x19, 0x10, 0x10, 0x10,		# r
0x00, 0x00, 0x0f, 0x10, 0x0e, 0x01, 0x1e,		# s
0x04, 0x04, 0x0e, 0x04, 0x04, 0x05, 0x02,		# t
0x00, 0x00, 0x11, 0x11, 0x11, 0x11, 0x0e,		# u
0x00, 0x00, 0x11, 0x11, 0x11, 0x0a, 0x04,		# v
0x00, 0x00, 0x11, 0x15, 0x15, 0x15, 0x0a,		# w
0x00, 0x00, 0x11, 0x0a, 0x04, 0x0a, 0x11,		# x
0x00, 0x00, 0x11, 0x0a, 0x04, 0x04, 0x08,		# y
0x00, 0x00, 0x1f, 0x02, 0x04, 0x08, 0x1f,		# z
0x06, 0x08, 0x08, 0x10, 0x08, 0x08, 0x07,		# {
0x04, 0x04, 0x04, 0x04, 0x04, 0x04, 0x04,		# |
0x0c, 0x02, 0x02, 0x01, 0x02, 0x02, 0x0c,		# }
0x00, 0x00, 0x0c, 0x13, 0x00, 0x00, 0x00		# ~
]

xc2 = [
0x06, 0x09, 0x08, 0x1e, 0x08, 0x08, 0x1f
]

tb5 = [
0x02, 0x06, 0x02, 0x02, 0x07, 0x00, 0x00,
0x06, 0x01, 0x02, 0x04, 0x07, 0x00, 0x00,
0x07, 0x01, 0x03, 0x01, 0x07, 0x00, 0x00,
0x05, 0x05, 0x07, 0x01, 0x01, 0x00, 0x00,
0x07, 0x04, 0x07, 0x01, 0x07, 0x00, 0x00,
0x07, 0x04, 0x07, 0x05, 0x07, 0x00, 0x00,
0x07, 0x01, 0x02, 0x04, 0x04, 0x00, 0x00,
0x07, 0x05, 0x07, 0x05, 0x07, 0x00, 0x00,
0x07, 0x05, 0x07, 0x01, 0x01, 0x00, 0x00,
0x07, 0x05, 0x05, 0x05, 0x07, 0x00, 0x00
]

binary = [
0x07, 0x05, 0x05, 0x05, 0x07, 0x00, 0x00,
0x04, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
0x04, 0x04, 0x00, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
0x04, 0x00, 0x04, 0x00, 0x00, 0x00, 0x00,
0x00, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00,
0x04, 0x04, 0x04, 0x00, 0x00, 0x00, 0x00,
0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
0x04, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00
]

Pound = False
Time = 0

def Screen3by5(Array, Shift=0):
	count = 0
	Output = [[],[],[],[],[],[],[],[], [],[],[],[],[],[],[],[]]
	for Id, Byte in enumerate(Array):
		if count == 7:
			count = 0
		Output[count+Shift].append(Byte)
		count = count + 1
	for Id, Byte in enumerate(Output):
		if Id < Shift:
			Output[Id] = ["IGNORE"]
			continue
		if len(Output[Id]) > 1:
			Output[Id] = '0'.join(Byte)+"0"			# This will join the output arrays together and seperate with a 0
	return Output

def WriteToScreen3by5(Output):
	Xx = 0
	for X, Map in enumerate(Output):
		Xx = int(X)
		Yy = 0
		for Y in Map:
			if Y == "IGNORE":
				Yy = Yy + 1
				continue
			if Yy > 7 and Yy < 16:
#				printout(Y, colour=RED)
				if Yy == 15:
					continue
				Grid2.setPixel(Xx+1, Yy-7, int(Y))
				Yy = Yy + 1
				continue
			elif Yy > 15:
				continue
#			printout(Y, colour=GREEN)
			Grid1.setPixel(Xx+1, Yy, int(Y))
			Yy = Yy + 1
	return Output

def WriteOut3by5(Sentence, Line=0, Update=False):
	global H
	global M
	Output = []
	Character = []
	for B, Char in enumerate(Sentence):
		for Pix in range(0, 7):
			Tmp = (int(Char)-1)*7
			Character.append( '{:03b}'.format(tb5[Tmp+Pix]) )
	Ret = Screen3by5(Character, Line)
	Ret = WriteToScreen3by5(Ret)
	if Update:
		return
	Grid2.setPixel(2, 0, 1)
	Grid2.setPixel(4, 0, 1)
	time.sleep(0.5)
	Grid2.setPixel(2, 0, 0)
	Grid2.setPixel(4, 0, 0)
	if time.strftime("%H") != H or time.strftime("%M") != M:
		H,M = time.strftime("%H"), time.strftime("%M")
		WriteOut3by5("{}{}".format(H, M), Line=0)
	time.sleep(0.5)
	return




##################################################################


def Screen(Array, Shift=0):
	count = 0
	Output = [[],[],[],[],[],[],[],[], [],[],[],[],[],[],[],[]]
	for Id, Byte in enumerate(Array):
		if count == 7:
			count = 0
		Output[count+Shift].append(Byte)
		count = count + 1
	for Id, Byte in enumerate(Output):
		if Id < Shift:
			Output[Id] = ["IGNORE"]
			continue
		if len(Output[Id]) > 1:
			Output[Id] = '0'.join(Byte)+"000"			# This will join the output arrays together and seperate with a 0
	return Output

def WriteToScreen(Output):
	Xx = 0
	for X, Map in enumerate(Output):
		Xx = int(X)
		Yy = 0
		for Y in Map:
			if Y == "IGNORE":
				Yy = Yy + 1
				continue
			if Yy > 7 and Yy < 16:
#				printout(Y, colour=RED)
				Grid2.setPixel(Xx, Yy-8, int(Y))
				Yy = Yy + 1
				continue
			elif Yy > 16:
				continue
#			printout(Y, colour=GREEN)
			Grid1.setPixel(Xx, Yy, int(Y))
			Yy = Yy + 1
#		print ""
	return Output

def WriteOut(Sentence, Line=0, Scroll=False, Update=False):
	global Time
	Output = []
	Character = []
	for B, Char in enumerate(Sentence):
		if ord(Char) == 163:
			continue
		if ord(Char) == 194:
			for A in range(0, 7):
				Character.append('{:08b}'.format(xc2[A])[3:])
		else:
			for Pix in range(0, 7):
				Character.append( '{:08b}'.format(Font[((ord(Char)-32)*7)+Pix])[3:] )
	if Update:
		return
	Ret = Screen(Character, Line)
	Ret = WriteToScreen(Ret)
	if Scroll:
		while True:
			global H
			global M
			Array = []
			if time.strftime("%H") != H or time.strftime("%M") != M:
				H,M = time.strftime("%H"), time.strftime("%M")
				WriteOut3by5("{}{}".format(H, M), Line=0, Update=True)
			for A in Ret:
				if len(A) < 1:
					continue
				A = list(A)
				Pop = A.pop(0)
				A.append(Pop)
				Array.append( A )
			if Time:
				Grid2.setPixel(2, 0, 1)
				Grid2.setPixel(4, 0, 1)
				time.sleep(0.5)
				Grid2.setPixel(2, 0, 0)
				Grid2.setPixel(4, 0, 0)
			Ret = WriteToScreen(Array)


#################################################

Read = True
while True:
	global H
	global M
	H = M = 0
	global Time
	Time = 1
	H,M = time.strftime("%H"), time.strftime("%M")
	WriteOut3by5("{}{}".format(H, M), Line=0)
	News = Update_News(BBC)
	WriteOut(News, Line=8, Scroll=True)
