import argparse, sys, time, re,  os
from subprocess import Popen, PIPE

parse = argparse.ArgumentParser(description='RSS Feed download and display.')

parse.add_argument('update', metavar='D', type=int, default=300,
		help='The refresh rate for the RSS Feed in seconds, Recommended 300 ( 5 minutes )')
parse.add_argument('max', metavar='M', type=int, default=20,
		help='The maximum news articles to print. Defaults to 20')

args = parse.parse_args()
Update = args.update
Max = args.max
BBC = 'feeds.bbci.co.uk/news/rss.xml?edition=uk'
os.system("clear")

BLACK, RED, GREEN, ORANGE, BLUE, MAGENTA, CYAN, WHITE = 30, 31, 32, 33, 34, 35, 36, 37

def printout(text, colour=WHITE):
	seq = "\x1b[%sm%s\x1b[0m" % (colour, text)
	sys.stdout.write(seq)
	sys.stdout.flush()

def Update_News(Url):
	News = []
	Video = []
	Audio = []
	Pictures = []
	DNull = open('/dev/null', 'w')
	printout("\nDownloading BBC RSS Feed. ", CYAN)
	Args = ['curl' , Url]
	Proc = Popen(Args, stdout=PIPE, stderr=DNull)
	printout("[DONE]\n", RED)
	Out = Proc.stdout.read()
	Find = re.findall("<title>([\S ]*)</title>", Out)
	Find.pop(0)
	Find.pop(0)

	for A in Find:
		if A[:5] == "VIDEO":
			Video.append(A[7:])
		elif A[:5] == "AUDIO":
			Audio.append(A[7:])
		elif A[:11] == "In pictures":
			Pictures.append(A[13:])
		elif A[:15] == "Day in pictures":
			Pictures.append(A[17:])
		else:
			News.append(A)

	return News, Video, Audio, Pictures

while True:
	os.system("clear")
	News, Video, Audio, Pictures = Update_News(BBC)
	Count = 1
	for A in News:
		if Count > Max:
			News = []
			continue
		if Count < 10:
			Space = " "
		else:
			Space = ""
		printout(str(Count)+") "+Space+A+"\n", GREEN)
		Count = Count + 1
	print "\n"
	time.sleep(Update)
